library pack1076;
use pack1076.pack1076.all;


package LPMCNT8_ip is
   function incr (x: vlbit_vector) return vlbit_vector;
   function decr (x: vlbit_vector) return vlbit_vector;
   function incdec (x: vlbit_vector; u: vlbit) return vlbit_vector;
end;
package body LPMCNT8_ip is
   function incdec (x: vlbit_vector; u: vlbit) return vlbit_vector is
      variable carry: vlbit := '0';
      variable d: vlbit := '0';
      variable sum: vlbit_vector (7 downto 0) := "00000000";
   begin
      carry := u; d := not u;
      for i in 0 to x'left loop
         sum(i) := x(i) xor carry xor d;
         carry := (x(i) and carry) or (x(i) and d) or (carry and d);
      end loop;
      return sum;
   end;
   function incr (x: vlbit_vector) return vlbit_vector is
      variable carry: vlbit := '1';
      variable sum: vlbit_vector (7 downto 0) := "00000000";
   begin
      for i in 0 to x'left loop
         sum(i) := x(i) xor carry;
         carry := x(i) and carry;
      end loop;
      return sum;
   end;
   function decr (x: vlbit_vector) return vlbit_vector is
      variable carry: vlbit := '0';
      variable sum: vlbit_vector (7 downto 0) := "00000000";
   begin
      for i in 0 to x'left loop
         sum(i) := not (x(i) xor carry);
         carry := x(i) or carry;
      end loop;
      return sum;
   end;
end LPMCNT8_ip;


use work.LPMCNT8_ip.all;
library pack1076;
use pack1076.pack1076.all;


entity LPMCNT8 is port (
   signal Clock: in vlbit;
   signal Enable: in vlbit;
   signal Q: out vlbit_vector (7 downto 0));
end LPMCNT8;

architecture lpm of LPMCNT8 is
   constant b_0: vlbit_vector (7 downto 0) := "00000000";
   constant b_modless1: vlbit_vector (7 downto 0) := "11111111";
   signal int_data, int_q: vlbit_vector (7 downto 0);
   signal int_tc: vlbit;
   signal int_enable: vlbit;
begin

   -- Set up internal copies of control signals, if any
   int_enable <= Enable;

   -- Decode terminal value (may not be needed)
   int_tc <= '1' when (int_q = b_modless1) else '0';

   -- Synchronous assignment
   int_data <=
      b_0 when (int_tc = '1') else
      incr (int_q);

   -- Register and async assignment
   process begin
      wait until (Clock'event and Clock = '1');
         if (int_enable = '1') then int_q <= int_data; end if;
   end process;

   -- Produce output
   Q <= int_q after 0 ns;
end lpm;
